from django.urls import path
from .views import ProductListView, ProductDetailView, ProductCreateView, ProductUpdateView, ProductDeleteView, LineListView, LineCreateView, LineDetailView, LineUpdateView, LineDeleteView, SachetListView, SachetDetailView, SachetCreateView, SachetUpdateView, SachetDeleteView, product_list_api, line_list_api, sachet_defects_api, set_case_code_api
from . import views_defect
from .apis import recent_activities_api

""" utils """
urlpatterns = [
    path('products/', ProductListView.as_view(), name='products'),
    path('products/create/', ProductCreateView.as_view(), name='create'),
    path('products/detail/<int:pk>/', ProductDetailView.as_view(), name='detail'),
    path('products/update/<int:pk>/', ProductUpdateView.as_view(), name='update'),
    path('products/delete/<int:pk>/', ProductDeleteView.as_view(), name='delete'),

    path('lines/', LineListView.as_view(), name='lines'),
    path('lines/create/', LineCreateView.as_view(), name='create'),
    path('lines/detail/<int:pk>/', LineDetailView.as_view(), name='detail'),
    path('lines/update/<int:pk>/', LineUpdateView.as_view(), name='update'),
    path('lines/delete/<int:pk>/', LineDeleteView.as_view(), name='delete'),

    path('sachet/', SachetListView.as_view(), name='lines'),
    path('sachet/create/', SachetCreateView.as_view(), name='create'),
    path('sachet/detail/<int:pk>/', SachetDetailView.as_view(), name='detail'),
    path('sachet/update/<int:pk>/', SachetUpdateView.as_view(), name='update'),
    path('sachet/delete/<int:pk>/', SachetDeleteView.as_view(), name='delete'),

    path('defect/list/', views_defect.SachetDefectListView.as_view(), name='defect_list'),
    path('defect/create/', views_defect.SachetDefectCreateView.as_view(), name='defect_create'),

    path('products/', product_list_api),
    path('products/<int:pk>/', product_list_api),
    path('lines/', line_list_api),
    path('lines/<int:pk>/', line_list_api),
    path('sachet_defects/', sachet_defects_api),
    path('sachet_defects/<int:pk>/', sachet_defects_api),

    path('set_case_code/', set_case_code_api),
    path('recent_activities_api/', recent_activities_api)
]
