from django.db import models

class LinesModel(models.Model):
    line = models.IntegerField(unique=True)
    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'FACTORY LINES LIST'
         ordering = ('line',)

    def __str__(self) -> str:
        return f"{self.line}"


class SachetModel(models.Model):
    machine = models.IntegerField(unique=True)
    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'FACTORY SACHET MACHINES LIST'
         ordering = ('machine',)

    def __str__(self) -> str:
        return f"{self.machine}"


PRODUCT_CHOICES = (("ALCOHOLIC", "ALCOHOLIC"), ("LOW-ALCOHOLIC", "LOW-ALCOHOLIC"), ("NON-ALCOHOLIC", "NON-ALCOHOLIC"), ("OTHER", "OTHER"))
PRODUCT_SECTION = (("LINE", "LINE"), ("SACHET", "SACHET"))

class ProductsModel(models.Model):
    product_name = models.CharField(max_length=30)
    product_name_short = models.CharField(max_length=5)
    product_size = models.IntegerField()
    case_quantity = models.IntegerField()
    product_type = models.CharField(max_length=24, choices=PRODUCT_CHOICES)
    product_section = models.CharField(max_length=24, choices=PRODUCT_SECTION, default='')
    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'ALL PRODUCTS LIST'
         ordering = ('product_name', '-product_size')

    def __str__(self) -> str:
        return f"{self.product_name} / {self.product_size} by {self.case_quantity}"


DEFECT_CHOICES = (("MINOR", "MINOR"), ("MAJOR", "MAJOR"), ("CRITICAL", "CRITICAL"))
class SachetDefectsModel(models.Model):
    defect_code = models.CharField(max_length=5)
    defect_description = models.CharField(max_length=30)
    defect_category = models.CharField(max_length=12, choices=DEFECT_CHOICES)
    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'ALL SACHET DEFECTS LIST'
         ordering = ('defect_code',)

    def __str__(self) -> str:
        return f"{self.defect_code} : {self.defect_description}"






SHIFTS = {"MORNING" : ["06", "07", "08", "09", "10", "11", "12", "13"], "AFTERNOON":["14", "15", "16", "17", "18", "19", "20"], "NIGHT":["21", "22", "23", "00", "01", "02", "03", "04", "05"], "DAY":["08", "09", "10", "11", "12", "13", "14", "15", "16"]}
