from django.shortcuts import render, redirect
from django.contrib.auth.decorators import login_required
from django.utils import timezone
from datetime import datetime, date
from django.db.models import F, Sum, Avg
from django.db.models import Q
from itertools import chain
from datetime import datetime, date, timedelta
from django.http.response import JsonResponse
from accounts.models import UsersActivitiesModel

@login_required(login_url='/login')
def recent_activities_api(request):
    activities = UsersActivitiesModel.objects.all().order_by('-id')[:20]
    acts = []
    for a in activities:
        acts.append({'activity':f"{a.get_model_redirect_url()[1].replace('_', ' ')} : {a.activity}", 'link':a.get_model_redirect_url()[0], 'description':a.description, 'created_by':a.created_by, 'datetime_created':datetime.strftime(a.datetime_created, '%x')})
    return JsonResponse(acts, safe=False)