from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth.decorators import login_required
from django.utils import timezone
from django.contrib import messages
from .forms import SachetInspectionSubmitWorkflowForm, SachetInspectionCheckWorkflowForm, SachetInspectionApprovalWorkflowForm
from .models import SachetInspectionWorkFlowModel
from django.views.decorators.cache import cache_page
from accounts.fxns import user_activity





""" SUBMIT INSPECTION FORM WORKFLOW """
@login_required(login_url='/login')
def sachet_inspection_workflow_submit(request, pk):

    query = get_object_or_404(SachetInspectionWorkFlowModel, pk=pk)

    if request.method == 'POST':
        
        form = SachetInspectionSubmitWorkflowForm(request.POST, instance=query)
        if form.is_valid():
            obj = form.save(commit=False)
            obj.analysed_by = request.user.username
            obj.analysed_datetime = timezone.now()
            obj.save()

            query.machine_id.status = 'ANALYSED'
            query.machine_id.save()

            """ USER ACTIVITY """
            user_activity(request, model_name='SACHET_INSPECTION', model_id=query.id, activity='SUBMIT', description=f"Sachet {query.machine_id.mc_id.machine} Inspection form Submitted")

            messages.success(request, 'Form submitted successfully')
            return redirect(f'/sachet/inspection/detail/{query.machine_id.id}/')
        messages.error(request, 'Network Error, form not submitted!!!')
        return redirect(f'/sachet/inspection/detail/{query.machine_id.id}/')
    messages.error(request, 'Method not allowed!!!')
    return redirect(f'/sachet/inspection/detail/{query.machine_id.id}/')



""" CHECK INSPECTION FORM WORKFLOW """
@login_required(login_url='/login')
def sachet_inspection_workflow_check(request, pk):

    query = get_object_or_404(SachetInspectionWorkFlowModel, pk=pk)

    if request.method == 'POST':
        form = SachetInspectionCheckWorkflowForm(request.POST, instance=query)
        if form.is_valid():
            obj = form.save(commit=False)
            obj.checked_by = request.user.username
            obj.checked_datetime = timezone.now()
            obj.save()

            query.machine_id.status = 'CHECKED'
            query.machine_id.save()

            """ USER ACTIVITY """
            user_activity(request, model_name='SACHET_INSPECTION', model_id=query.id, activity='CHECK', description=f"Sachet {query.machine_id.mc_id.machine} Inspection form Checked")

            messages.success(request, 'Form checked successfully')
            return redirect(f'/sachet/inspection/detail/{query.machine_id.id}/')
        messages.error(request, 'Network Error, form not checked!!!')
        return redirect(f'/sachet/inspection/detail/{query.machine_id.id}/')
    messages.error(request, 'Method not allowed!!!')
    return redirect(f'/sachet/inspection/detail/{query.machine_id.id}/')




""" APPROVAL INSPECTION FORM WORKFLOW """
@login_required(login_url='/login')
def sachet_inspection_workflow_approval(request, pk):

    query = get_object_or_404(SachetInspectionWorkFlowModel, pk=pk)

    if request.method == 'POST':
        form = SachetInspectionApprovalWorkflowForm(request.POST, instance=query)
        if form.is_valid():
            obj = form.save(commit=False)
            obj.approved_by = request.user.username
            obj.approved_datetime = timezone.now()
            obj.save()

            query.machine_id.status = 'APPROVED'
            query.machine_id.save()

            """ USER ACTIVITY """
            user_activity(request, model_name='SACHET_INSPECTION', model_id=query.id, activity='APPROVE', description=f"Sachet {query.machine_id.mc_id.machine} Inspection form Approved")

            messages.success(request, 'Form Approved successfully')
            return redirect(f'/sachet/inspection/detail/{query.machine_id.id}/')
        messages.error(request, 'Network Error, form not Approved!!!')
        return redirect(f'/sachet/inspection/detail/{query.machine_id.id}/')
    messages.error(request, 'Method not allowed!!!')
    return redirect(f'/sachet/inspection/detail/{query.machine_id.id}/')