from django.shortcuts import render, redirect, get_object_or_404
from .models import SachetInspectionFaultModel
from .models_analysis import SachetInspectionAlcModel
from .forms import SachetInspectionAlcUpdateForm, SachetInspectionDefectForm, SachetInspectionFaultUpdateForm
from django.contrib.auth.decorators import login_required
from django.contrib import messages


""" SACHET INSPECTION HOURLY DETAILS =================================================================================================== """
@login_required(login_url='/login')
#@cache_page(60 * 30)
def sachet_inspection_hourly_detail(request, form_pk, hour_pk):
    template_name = 'hourly/sachet_inspection_hourly_detail.html'
    #query = get_object_or_404(LineAlcModel, pk=pk)

    query = SachetInspectionAlcModel.objects.select_related('machine_id').filter(pk=hour_pk).first()

    if request.method == 'POST':
        form = SachetInspectionAlcUpdateForm(request.POST, instance=query)
        if form.is_valid():
            form.save()
            messages.success(request, f'{query.hour} Hour Sachet inspection Updated')
            return redirect(f'/sachet/inspection/hour/{form_pk}/{hour_pk}/')
        messages.error(request, 'Error in Connection!!!')
        return redirect(f'/sachet/inspection/hour/{form_pk}/{hour_pk}/')
    else:
        defect = query.machine_id.defect.filter(hour=query.hour)
        context = {
            'data':query,
            'defect':defect,
            'form': SachetInspectionAlcUpdateForm(instance=query),
            'defect_form': SachetInspectionDefectForm()
        }
    return render(request, template_name, context)


""" SACHET INSPECTION HOURLY DELETE =================================================================================================== """
@login_required(login_url='/login')
def sachet_inspection_hourly_delete(request, pk):
    query = get_object_or_404(SachetInspectionAlcModel, pk=pk)

    if request.method == 'POST':
        yes_no = request.POST.get('yes_no')
        if yes_no == 'YES':
            query.delete()
            messages.success(request, 'Sachet Hourly inspection Deleted')
            return redirect(f'/sachet/inspection/detail/{query.machine_id.id}/')
        messages.error(request, 'Error in Connection!!!')
        return redirect(f'/sachet/inspection/hour/{query.machine_id.id}/{pk}/')



""" SACHET INSPECTION DEFECT OBSERVED HOURLY =================================================================================================== """
@login_required(login_url='/login')
def create_defect(request, pk):
    query = get_object_or_404(SachetInspectionAlcModel, pk=pk)

    if request.method == 'POST':
        form = SachetInspectionDefectForm(request.POST)
        if form.is_valid():
            obj = form.save(commit=False)
            obj.machine_id = query.machine_id
            obj.hour = query.hour
            obj.created_by = request.user.username
            obj.save()
            messages.success(request, 'Sachet Defect added successfully')
            return redirect(f'/sachet/inspection/hour/{query.machine_id.id}/{pk}/')
        messages.error(request, 'Error in Connection!!!')
        return redirect(f'/sachet/inspection/hour/{query.machine_id.id}/{pk}/')
    messages.error(request, 'Method not Allowed!!!')
    return redirect(f'/sachet/inspection/hour/{query.machine_id.id}/{pk}/')




""" SACHET INSPECTION FAULT DETAILS =================================================================================================== """
@login_required(login_url='/login')
#@cache_page(60 * 30)
def sachet_inspection_fault_detail(request, pk):
    template_name = 'fault/sachet_inspection_fault_detail.html'
    query = SachetInspectionFaultModel.objects.select_related('machine_id').filter(pk=pk).first()

    if not query:
        messages.error(request, 'Not Found!!!')
        return redirect(f'/sachet/inspection/')

    if request.method == 'POST':
        form = SachetInspectionFaultUpdateForm(request.POST, instance=query)
        if form.is_valid():
            form.save()
            messages.success(request, f'{query.hour} Hour Fault Updated')
            return redirect(f'/sachet/inspection/fault/{pk}')
        messages.error(request, 'Error in Connection!!!')
        return redirect(f'/sachet/inspection/fault/{pk}')
    else:
        context = {
            'data':query,
            'form':SachetInspectionFaultUpdateForm(instance=query),
        }
    return render(request, template_name, context)


""" SACHET INSPECTION FAULT DELETE =================================================================================================== """
@login_required(login_url='/login')
def sachet_inspection_fault_delete(request, pk):

    if request.method == 'POST':
        yes_no = request.POST.get('yes_no')
        if yes_no == 'YES':
            query = get_object_or_404(SachetInspectionFaultModel, pk=pk)       
            query.delete()
            messages.success(request, 'Sachet Fault Deleted')
            return redirect(f'/sachet/inspection/detail/{query.machine_id.id}/')
        messages.error(request, 'Error in Connection!!!')
        return redirect(f'/sachet/inspection/fault/{pk}/')
    messages.error(request, 'Method not Allowed!!!')
    return redirect(f'/sachet/inspection/fault/{pk}/')


