from django.urls import path
from . import views, views_analysis, views_workflow


""" sachet/inspection """
urlpatterns = [
    path('', views.sachet_inspection, name='sachet_list'),
    path('detail/<int:pk>/', views.sachet_inspection_detail, name='sachet_detail'),

    path('delete/<int:pk>/', views.sachet_inspection_delete),
    path('analysis/<int:pk>/', views.sachet_inspection_hourly), #CREATE HOURLY ANALYSIS
    path('hour/delete/<int:pk>/', views_analysis.sachet_inspection_hourly_delete), #DELETE HOURLY ANALYSIS

    path('hour/<int:form_pk>/<int:hour_pk>/', views_analysis.sachet_inspection_hourly_detail), ## VIEW DETAILS OF HOURLY ANALYSIS
    
    path('create_fault/<int:pk>/', views.sachet_inspection_create_fault), ## CREATE HOURLY FAULT
    path('fault/<int:pk>/', views_analysis.sachet_inspection_fault_detail), ## CREATE HOURLY FAULT
    path('fault/delete/<int:pk>/', views_analysis.sachet_inspection_fault_delete), ## CREATE HOURLY FAULT

    path('submit/<int:pk>/', views_workflow.sachet_inspection_workflow_submit),
    path('check/<int:pk>/', views_workflow.sachet_inspection_workflow_check),
    path('approve/<int:pk>/', views_workflow.sachet_inspection_workflow_approval),

    path('form/<int:pk>/', views.sachet_inspection_form), ### ANALYSIS FORM PRINT OUT

    path('file/upload/<int:pk>/', views.file_upload),
    path('file/delete/<int:pk>/', views.file_delete),

    path('defect/create/<int:pk>/', views_analysis.create_defect), ### PK FOR HOURLY ANALYSIS
    path('defect/delete/<int:pk>/', views.defect_delete),

    path('pkg/add/<int:pk>/', views.pkg_code_add),
    path('pkg/delete/<int:pk>/', views.pkg_code_delete),

    path('pallet/add/<int:pk>/', views.pallet_add),
    path('pallet/delete/<int:pk>/', views.pallet_delete)

]