from django.db import models
from .models import SachetInspectionModel, HOUR_CHOICE

SELECTION_CHOICE = (("OKAY", "OKAY"), ("NOT OKAY", "NOT OKAY"), ("OTHER", "OTHER"))

class SachetInspectionAlcModel(models.Model):
    machine_id = models.ForeignKey(SachetInspectionModel, related_name='hourly', on_delete=models.CASCADE)
    hour = models.CharField(max_length= 6, choices=HOUR_CHOICE)
    taste = models.CharField(max_length= 9, choices=SELECTION_CHOICE)
    volume = models.FloatField()
    weight = models.FloatField()
    case_stamp_code = models.CharField(max_length= 24)
    burst_time = models.CharField(max_length= 9, choices=SELECTION_CHOICE)
    comment = models.TextField(null=True, blank=True)

    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'SACHET HOURLY INSPECTION'
         ordering = ('machine_id__date', 'machine_id__shift', 'machine_id__mc_id__machine', 'hour')

    def __str__(self) -> str:
        return f'HOUR : {self.hour}, DATE : {self.machine_id.date}, MACHINE : {self.machine_id.mc_id.machine}'


