# Generated by Django 3.2.16 on 2023-02-23 04:32

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('utilz', '0008_productsmodel_case_quantity'),
    ]

    operations = [
        migrations.CreateModel(
            name='SachetInspectionModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(default=django.utils.timezone.now)),
                ('shift', models.CharField(choices=[('MORNING', 'MORNING'), ('AFTERNOON', 'AFTERNOON'), ('NIGHT', 'NIGHT'), ('DAY', 'DAY')], max_length=12)),
                ('blend_number', models.CharField(max_length=24)),
                ('inspector', models.CharField(max_length=30)),
                ('supervisor', models.CharField(blank=True, max_length=30, null=True)),
                ('machine_operators', models.CharField(blank=True, max_length=30, null=True)),
                ('packers', models.CharField(blank=True, max_length=60, null=True)),
                ('status', models.CharField(choices=[('CREATED', 'CREATED'), ('ANALYSED', 'ANALYSED'), ('CHECKED', 'CHECKED'), ('APPROVED', 'APPROVED')], default='CREATED', max_length=12)),
                ('comment', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('mc_id', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='m_id', to='utilz.sachetmodel')),
                ('product_id', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='product_si', to='utilz.productsmodel')),
            ],
            options={
                'verbose_name_plural': 'SACHET INSPECTION SHIFT FORM',
                'ordering': ('date', 'shift', 'mc_id__machine'),
            },
        ),
        migrations.CreateModel(
            name='SachetInspectionWorkFlowModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('analysed_by', models.CharField(blank=True, max_length=24, null=True)),
                ('analysed_comment', models.TextField(blank=True, null=True)),
                ('analysed_datetime', models.DateTimeField(blank=True, null=True)),
                ('checked_by', models.CharField(blank=True, max_length=24, null=True)),
                ('checked_comment', models.TextField(blank=True, null=True)),
                ('checked_datetime', models.DateTimeField(blank=True, null=True)),
                ('approved_by', models.CharField(blank=True, max_length=24, null=True)),
                ('approved_comment', models.TextField(blank=True, null=True)),
                ('approved_datetime', models.DateTimeField(blank=True, null=True)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('machine_id', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='workflow', to='sachet_inspection.sachetinspectionmodel')),
            ],
            options={
                'verbose_name_plural': 'SACHET INSPECTION SHIFT WORKFLOW',
                'ordering': ('machine_id__date', 'machine_id__shift', 'machine_id__mc_id__machine'),
            },
        ),
        migrations.CreateModel(
            name='SachetInspectionPkgCodeModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('material_type', models.CharField(max_length=12)),
                ('pkg_code', models.CharField(max_length=30)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('machine_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='pkg_code', to='sachet_inspection.sachetinspectionmodel')),
            ],
            options={
                'verbose_name_plural': 'SACHET INSPECTION PKG CODES',
                'ordering': ('machine_id',),
            },
        ),
        migrations.CreateModel(
            name='SachetInspectionFilesModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(blank=True, null=True, upload_to='files_folder', validators=[django.core.validators.FileExtensionValidator(['png', 'jpg', 'jpeg', 'pdf', 'doc', 'docx', 'cdr'])])),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('machine_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='files', to='sachet_inspection.sachetinspectionmodel')),
            ],
            options={
                'verbose_name_plural': 'SACHET INSPECTION UPLOADED FILES',
                'ordering': ('machine_id__date', 'machine_id__shift', 'machine_id__mc_id__machine'),
            },
        ),
        migrations.CreateModel(
            name='SachetInspectionFaultModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hour', models.CharField(choices=[('00', '00'), ('01', '01'), ('02', '02'), ('03', '03'), ('04', '04'), ('05', '05'), ('06', '06'), ('07', '07'), ('08', '08'), ('09', '09'), ('10', '10'), ('11', '11'), ('12', '12'), ('13', '13'), ('14', '14'), ('15', '15'), ('16', '16'), ('17', '17'), ('18', '18'), ('19', '19'), ('20', '20'), ('21', '21'), ('22', '22'), ('23', '23')], max_length=6)),
                ('fault', models.TextField()),
                ('corrective_action', models.TextField(blank=True, null=True)),
                ('result', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('machine_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fault', to='sachet_inspection.sachetinspectionmodel')),
            ],
            options={
                'verbose_name_plural': 'SACHET INSPECTION FAULT BOX',
                'ordering': ('machine_id__date', 'machine_id__shift', 'machine_id__mc_id__machine', 'hour'),
            },
        ),
        migrations.CreateModel(
            name='SachetInspectionDefectModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hour', models.CharField(choices=[('00', '00'), ('01', '01'), ('02', '02'), ('03', '03'), ('04', '04'), ('05', '05'), ('06', '06'), ('07', '07'), ('08', '08'), ('09', '09'), ('10', '10'), ('11', '11'), ('12', '12'), ('13', '13'), ('14', '14'), ('15', '15'), ('16', '16'), ('17', '17'), ('18', '18'), ('19', '19'), ('20', '20'), ('21', '21'), ('22', '22'), ('23', '23')], max_length=6)),
                ('quantity', models.IntegerField()),
                ('defect_cause', models.CharField(choices=[('RAW MATERIAL', 'M : RAW MATERIAL'), ('ENGINEERING', 'E : ENGINEERING'), ('MAINTENANCE SETTING', 'W : MAINTENANCE SETTING'), ('HUMAN', 'O : HUMAN')], max_length=24)),
                ('comment', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('defect_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='defect_id', to='utilz.sachetdefectsmodel')),
                ('machine_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='defect', to='sachet_inspection.sachetinspectionmodel')),
            ],
            options={
                'verbose_name_plural': 'SACHET INSPECTION DEFECT RECORD',
                'ordering': ('machine_id__date', 'machine_id__shift', 'machine_id__mc_id__machine', 'hour'),
            },
        ),
        migrations.CreateModel(
            name='SachetInspectionAlcModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hour', models.CharField(choices=[('00', '00'), ('01', '01'), ('02', '02'), ('03', '03'), ('04', '04'), ('05', '05'), ('06', '06'), ('07', '07'), ('08', '08'), ('09', '09'), ('10', '10'), ('11', '11'), ('12', '12'), ('13', '13'), ('14', '14'), ('15', '15'), ('16', '16'), ('17', '17'), ('18', '18'), ('19', '19'), ('20', '20'), ('21', '21'), ('22', '22'), ('23', '23')], max_length=6)),
                ('taste', models.CharField(choices=[('OKAY', 'OKAY'), ('NOT OKAY', 'NOT OKAY'), ('OTHER', 'OTHER')], max_length=9)),
                ('volume', models.FloatField()),
                ('weight', models.FloatField()),
                ('case_stamp_code', models.CharField(max_length=24)),
                ('burst_time', models.CharField(choices=[('OKAY', 'OKAY'), ('NOT OKAY', 'NOT OKAY'), ('OTHER', 'OTHER')], max_length=9)),
                ('comment', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('machine_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='hourly', to='sachet_inspection.sachetinspectionmodel')),
            ],
            options={
                'verbose_name_plural': 'SACHET HOURLY INSPECTION',
                'ordering': ('machine_id__date', 'machine_id__shift', 'machine_id__mc_id__machine', 'hour'),
            },
        ),
    ]
