from django.forms import ModelForm
from .models import SachetInspectionModel, SachetInspectionPkgCodeModel, SachetInspectionFaultModel, SachetInspectionDefectModel, SachetInspectionDespatchPalletModel, SachetInspectionWorkFlowModel, SachetInspectionFilesModel
from .models_analysis import SachetInspectionAlcModel
from utilz.models import ProductsModel, SachetModel



""" SACHET INSPECTION FORM """
class SachetInspectionForm(ModelForm):
    def __init__(self,*args,**kwargs):
        super (SachetInspectionForm ,self ).__init__(*args,**kwargs) # populates the post
        self.fields['product_id'].queryset = ProductsModel.objects.filter(product_section="SACHET")
        self.fields['mc_id'].queryset = SachetModel.objects.all()

    class Meta:
        model = SachetInspectionModel
        #fields = ['pub_date', 'headline', 'content', 'reporter']
        exclude = ['status', 'datetime_created', 'created_by']


""" SACHET INSPECTION UPDATE FORM """
class SachetInspectionUpdateForm(ModelForm):
    def __init__(self,*args,**kwargs):
        super (SachetInspectionUpdateForm ,self ).__init__(*args,**kwargs) # populates the post
        self.fields['product_id'].queryset = ProductsModel.objects.filter(product_section="SACHET")
        #self.fields['mc_id'].queryset = SachetModel.objects.all()

    class Meta:
        model = SachetInspectionModel
        #fields = ['pub_date', 'headline', 'content', 'reporter']
        exclude = ['mc_id', 'date', 'status', 'datetime_created', 'created_by']


""" SACHET INSPECTION PKG CODE FORM """
class SachetInspectionPkgCodeForm(ModelForm):
    class Meta:
        model = SachetInspectionPkgCodeModel
        exclude = ['machine_id', 'datetime_created', 'created_by']




""" SACHET INSPECTION FAULT FORM """
class SachetInspectionFaultForm(ModelForm):
    class Meta:
        model = SachetInspectionFaultModel
        exclude = ['machine_id', 'datetime_created', 'created_by']


""" SACHET INSPECTION FAULT UPDATE FORM """
class SachetInspectionFaultUpdateForm(ModelForm):
    class Meta:
        model = SachetInspectionFaultModel
        exclude = ['machine_id', 'hour', 'datetime_created', 'created_by']


""" SACHET INSPECTION DEFECT FORM """
class SachetInspectionDefectForm(ModelForm):
    class Meta:
        model = SachetInspectionDefectModel
        exclude = ['machine_id', 'hour', 'datetime_created', 'created_by']



""" SACHET INSPECTION HOURLY ALCOHOLIC FORM """
class SachetInspectionAlcForm(ModelForm):
    class Meta:
        model = SachetInspectionAlcModel
        exclude = ['machine_id', 'datetime_created', 'created_by']



""" SACHET INSPECTION HOURLY ALCOHOLIC UPDATE FORM """
class SachetInspectionAlcUpdateForm(ModelForm):
    class Meta:
        model = SachetInspectionAlcModel
        exclude = ['machine_id', 'hour', 'datetime_created', 'created_by']


""" SACHET INSPECTION DESPATCHED PRODUCT """
class SachetInspectionDespatchPalletForm(ModelForm):
    class Meta:
        model = SachetInspectionDespatchPalletModel
        exclude = ['machine_id', 'datetime_created', 'created_by']



""" SUBMIT SACHET FORM WORKFLOW FORM """
class SachetInspectionSubmitWorkflowForm(ModelForm):
    class Meta:
        model = SachetInspectionWorkFlowModel
        fields = ['analysed_comment']

    
""" CHECK LINE ANALYSIS WORKFLOW FORM """
class SachetInspectionCheckWorkflowForm(ModelForm):
    class Meta:
        model = SachetInspectionWorkFlowModel
        fields = ['checked_comment']


""" APPROVAL LINE ANALYSIS WORKFLOW FORM """
class SachetInspectionApprovalWorkflowForm(ModelForm):
    class Meta:
        model = SachetInspectionWorkFlowModel
        fields = ['approved_comment']



""" FILES UPLOAD FORM """
from django import forms
from typing import Any
class SachetInspectionFilesForm(forms.ModelForm):    
    file = forms.FileField(widget=forms.FileInput(attrs={"class": "col-12 form-control mb-3"}))
    class Meta:
        model = SachetInspectionFilesModel
        fields = ['file']

        def __init__(self, *args: Any, **kwargs: Any) -> None:
            super(SachetInspectionFilesForm, self).__init__(*args, **kwargs)

            self.fields['file'].help_text = None