from django.http.response import JsonResponse
from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth.decorators import login_required
from django.utils import timezone
from django.contrib import messages
from .forms import SachetAnalysisForm, SachetAlcoholicAnalysisForm, SachetFaultForm, SachetAnalysisSubmitWorkflowForm, SachetAnalysisCheckWorkflowForm, SachetAnalysisApprovalWorkflowForm, SachetAnalysisFilesModelForm
from .models import SachetAnalysisModel, SachetFaultModel, SachetDefectModel, SachetAnalysisWorkFlowModel, SachetAnalysisFilesModel
from .models_analysis import SachetAlcModel
from utilz.models import ProductsModel, LinesModel
from django.views.decorators.cache import cache_page
from utilz.fxns import set_case_code, set_shift_analysis_table
from accounts.fxns import user_activity





""" SUBMIT ANALYSIS FORM WORKFLOW """
@login_required(login_url='/login')
def sachet_analysis_workflow_submit(request, pk):

    query = get_object_or_404(SachetAnalysisWorkFlowModel, pk=pk)

    if request.method == 'POST':
        
        form = SachetAnalysisSubmitWorkflowForm(request.POST, instance=query)
        if form.is_valid():
            obj = form.save(commit=False)
            obj.analysed_by = request.user.username
            obj.analysed_datetime = timezone.now()
            obj.save()

            query.machine_id.status = 'ANALYSED'
            query.machine_id.save()

            """ USER ACTIVITY """
            user_activity(request, model_name='SACHET_ANALYSIS', model_id=query.id, activity='SUBMIT', description=f"Sachet {query.machine_id.mc_id.machine} Analysis form Submitted")

            messages.success(request, 'Form submitted successfully')
            return redirect(f'/sachet/analysis/detail/{query.machine_id.id}/')
        messages.error(request, 'Network Error, form not submitted!!!')
        return redirect(f'/sachet/analysis/detail/{query.machine_id.id}/')
    messages.error(request, 'Method not allowed!!!')
    return redirect(f'/sachet/analysis/detail/{query.machine_id.id}/')



""" CHECK ANALYSIS FORM WORKFLOW """
@login_required(login_url='/login')
def sachet_analysis_workflow_check(request, pk):

    query = get_object_or_404(SachetAnalysisWorkFlowModel, pk=pk)

    if request.method == 'POST':
        form = SachetAnalysisCheckWorkflowForm(request.POST, instance=query)
        if form.is_valid():
            obj = form.save(commit=False)
            obj.checked_by = request.user.username
            obj.checked_datetime = timezone.now()
            obj.save()

            query.machine_id.status = 'CHECKED'
            query.machine_id.save()

            """ USER ACTIVITY """
            user_activity(request, model_name='SACHET_ANALYSIS', model_id=query.id, activity='CHECK', description=f"Sachet {query.machine_id.mc_id.machine} Analysis form Checked")

            messages.success(request, 'Form checked successfully')
            return redirect(f'/sachet/analysis/detail/{query.machine_id.id}/')
        messages.error(request, 'Network Error, form not checked!!!')
        return redirect(f'/sachet/analysis/detail/{query.machine_id.id}/')
    messages.error(request, 'Method not allowed!!!')
    return redirect(f'/sachet/analysis/detail/{query.machine_id.id}/')




""" APPROVAL ANALYSIS FORM WORKFLOW """
@login_required(login_url='/login')
def sachet_analysis_workflow_approval(request, pk):

    query = get_object_or_404(SachetAnalysisWorkFlowModel, pk=pk)

    if request.method == 'POST':
        form = SachetAnalysisApprovalWorkflowForm(request.POST, instance=query)
        if form.is_valid():
            obj = form.save(commit=False)
            obj.approved_by = request.user.username
            obj.approved_datetime = timezone.now()
            obj.save()

            query.machine_id.status = 'APPROVED'
            query.machine_id.save()

            """ USER ACTIVITY """
            user_activity(request, model_name='SACHET_ANALYSIS', model_id=query.id, activity='APPROVE', description=f"Sachet {query.machine_id.mc_id.machine} Analysis form Approved")

            messages.success(request, 'Form Approved successfully')
            return redirect(f'/sachet/analysis/detail/{query.machine_id.id}/')
        messages.error(request, 'Network Error, form not Approved!!!')
        return redirect(f'/sachet/analysis/detail/{query.machine_id.id}/')
    messages.error(request, 'Method not allowed!!!')
    return redirect(f'/sachet/analysis/detail/{query.machine_id.id}/')