
from django.shortcuts import render, redirect, get_object_or_404
#from .models import LineAnalysisModel, LineFaultModel, LineWorkFlowModel
from .models_analysis import SachetAlcModel
from .forms import SachetAnalysisForm, SachetAlcoholicAnalysisForm, SachetAlcoholicAnalysisUpdateForm, SachetFaultForm, SachetFaultUpdateForm, SachetDefectForm, SachetAnalysisSubmitWorkflowForm, SachetAnalysisCheckWorkflowForm, SachetAnalysisApprovalWorkflowForm, SachetAnalysisFilesModelForm
from django.contrib.auth.decorators import login_required
from rest_framework import status
from rest_framework.response import Response
from rest_framework.parsers import JSONParser
from django.http.response import JsonResponse
from django.views.decorators.csrf import csrf_exempt
from rest_framework.authentication import TokenAuthentication
from rest_framework.permissions import IsAuthenticated
from rest_framework.decorators import api_view, renderer_classes, authentication_classes, permission_classes
from django.contrib import messages


""" SACHET ANALYSIS HOURLY DETAILS =================================================================================================== """
@login_required(login_url='/login')
#@cache_page(60 * 30)
def sachet_analysis_hourly_detail(request, form_pk, hour_pk):
    template_name = 'hourly/sachet_analysis_hourly_detail.html'
    #query = get_object_or_404(LineAlcModel, pk=pk)

    query = SachetAlcModel.objects.select_related('machine_id').filter(pk=hour_pk).first()

    if request.method == 'POST':
        form = SachetAlcoholicAnalysisUpdateForm(request.POST, instance=query)
        if form.is_valid():
            form.save()
            messages.success(request, f'{query.hour} Hour Sachet Analysis Updated')
            return redirect(f'/sachet/analysis/hour/{form_pk}/{hour_pk}/')
        messages.error(request, 'Error in Connection!!!')
        return redirect(f'/sachet/analysis/hour/{form_pk}/{hour_pk}/')
    else:
        defect = query.machine_id.defect.filter(hour=query.hour)
        context = {
            'data':query,
            'defect':defect,
            'form':SachetAlcoholicAnalysisUpdateForm(instance=query),
            'defect_form': SachetDefectForm()
        }
    return render(request, template_name, context)


""" SACHET ANALYSIS HOURLY DELETE =================================================================================================== """
@login_required(login_url='/login')
def sachet_analysis_hourly_delete(request, pk):
    query = get_object_or_404(SachetAlcModel, pk=pk)

    if request.method == 'POST':
        yes_no = request.POST.get('yes_no')
        if yes_no == 'YES':
            query.delete()
            messages.success(request, 'Sachet Hourly Analysis Deleted')
            return redirect(f'/sachet/analysis/detail/{query.machine_id.id}/')
        messages.error(request, 'Error in Connection!!!')
        return redirect(f'/sachet/analysis/hour/{query.machine_id.id}/{pk}/')



""" SACHET ANALYSIS DEFECT OBSERVED HOURLY =================================================================================================== """
@login_required(login_url='/login')
def create_defect(request, pk):
    query = get_object_or_404(SachetAlcModel, pk=pk)

    if request.method == 'POST':
        form = SachetDefectForm(request.POST)
        if form.is_valid():
            obj = form.save(commit=False)
            obj.machine_id = query.machine_id
            obj.hour = query.hour
            obj.created_by = request.user.username
            obj.save()
            messages.success(request, 'Sachet Defect added successfully')
            return redirect(f'/sachet/analysis/hour/{query.machine_id.id}/{pk}/')
        messages.error(request, 'Error in Connection!!!')
        return redirect(f'/sachet/analysis/hour/{query.machine_id.id}/{pk}/')
    messages.error(request, 'Method not Allowed!!!')
    return redirect(f'/sachet/analysis/hour/{query.machine_id.id}/{pk}/')




from .models import SachetFaultModel
""" SACHET ANALYSIS FAULT DETAILS =================================================================================================== """
@login_required(login_url='/login')
#@cache_page(60 * 30)
def sachet_analysis_fault_detail(request, pk):
    template_name = 'fault/sachet_analysis_fault_detail.html'
    query = SachetFaultModel.objects.select_related('machine_id').filter(pk=pk).first()

    if not query:
        messages.error(request, 'Not Found!!!')
        return redirect(f'/sachet/analysis/')

    if request.method == 'POST':
        form = SachetFaultUpdateForm(request.POST, instance=query)
        if form.is_valid():
            form.save()
            messages.success(request, f'{query.hour} Hour Fault Updated')
            return redirect(f'/sachet/analysis/fault/{pk}')
        messages.error(request, 'Error in Connection!!!')
        return redirect(f'/sachet/analysis/fault/{pk}')
    else:
        context = {
            'data':query,
            'form':SachetFaultUpdateForm(instance=query),
        }
    return render(request, template_name, context)


""" SACHET ANALYSIS FAULT DELETE =================================================================================================== """
@login_required(login_url='/login')
def sachet_analysis_fault_delete(request, pk):

    if request.method == 'POST':
        yes_no = request.POST.get('yes_no')
        if yes_no == 'YES':
            query = get_object_or_404(SachetFaultModel, pk=pk)       
            query.delete()
            messages.success(request, 'Sachet Fault Deleted')
            return redirect(f'/sachet/analysis/detail/{query.machine_id.id}/')
        messages.error(request, 'Error in Connection!!!')
        return redirect(f'/sachet/analysis/fault/{pk}/')
    messages.error(request, 'Method not Allowed!!!')
    return redirect(f'/sachet/analysis/fault/{pk}/')


