from django.urls import path
from .views import sachet_analysis_api, sachet_workflow_api, sachet_fault_api, sachet_defect_api
#from .views_analysis import sachet_alcoholic_api

from . import views, views_analysis, views_workflow


""" sachet/analysis """
urlpatterns = [
    path('', views.sachet_analysis, name='sachet_list'),
    path('detail/<int:pk>/', views.sachet_analysis_detail, name='sachet_detail'),

    path('delete/<int:pk>/', views.sachet_analysis_delete),
    path('analysis/<int:pk>/', views.sachet_analysis_hourly), #CREATE HOURLY ANALYSIS
    path('hour/delete/<int:pk>/', views_analysis.sachet_analysis_hourly_delete), #DELETE HOURLY ANALYSIS

    path('hour/<int:form_pk>/<int:hour_pk>/', views_analysis.sachet_analysis_hourly_detail), ## VIEW DETAILS OF HOURLY ANALYSIS
    
    path('create_fault/<int:pk>/', views.sachet_analysis_create_fault), ## CREATE HOURLY FAULT
    path('fault/<int:pk>/', views_analysis.sachet_analysis_fault_detail), ## CREATE HOURLY FAULT
    path('fault/delete/<int:pk>/', views_analysis.sachet_analysis_fault_delete), ## CREATE HOURLY FAULT

    path('submit/<int:pk>/', views_workflow.sachet_analysis_workflow_submit),
    path('check/<int:pk>/', views_workflow.sachet_analysis_workflow_check),
    path('approve/<int:pk>/', views_workflow.sachet_analysis_workflow_approval),

    path('form/<int:pk>/', views.sachet_analysis_form), ### ANALYSIS FORM PRINT OUT

    path('file/upload/<int:pk>/', views.file_upload),
    path('file/delete/<int:pk>/', views.file_delete),

    path('defect/create/<int:pk>/', views_analysis.create_defect), ### PK FOR HOURLY ANALYSIS
    path('defect/delete/<int:pk>/', views.defect_delete),





    #path('create/', views.SachetAnalysisCreateView.as_view(), name='sachet_create'),
    #path('form/', sachet_analysis_api),
    #path('form/<int:pk>/', sachet_analysis_api),
    #path('workflow/', sachet_workflow_api),
    #path('workflow/<int:pk>/', sachet_workflow_api),
    #path('fault/', sachet_fault_api),
    #path('fault/<int:pk>/', sachet_fault_api),
    #path('defect/', sachet_defect_api),
    #path('defect/<int:pk>/', sachet_defect_api),
    #path('alc_analysis/', sachet_alcoholic_api),
    #path('alc_analysis/<int:pk>/', sachet_alcoholic_api)
]