from django.db import models
from .models import SachetAnalysisModel, HOUR_CHOICE

SELECTION_CHOICE = (("OKAY", "OKAY"), ("NOT OKAY", "NOT OKAY"), ("OTHER", "OTHER"))

class SachetAlcModel(models.Model):
    machine_id = models.ForeignKey(SachetAnalysisModel, related_name='hourly', on_delete=models.CASCADE)
    hour = models.CharField(max_length= 6, choices=HOUR_CHOICE)
    taste = models.CharField(max_length= 9, choices=SELECTION_CHOICE)
    color = models.FloatField(null=True, blank=True)
    conductivity = models.FloatField()
    ph = models.FloatField()
    alcoholic_strength = models.FloatField()
    volume = models.FloatField()
    clarity = models.IntegerField(default=0)
    weight = models.FloatField()

    case_stamp_code = models.CharField(max_length= 24)
    comment = models.TextField(null=True, blank=True)

    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'SACHET HOURLY ANALYSIS'
         ordering = ('machine_id__date', 'machine_id__shift', 'machine_id__mc_id__machine', 'hour')

    def __str__(self) -> str:
        return f'HOUR : {self.hour}, DATE : {self.machine_id.date}, MACHINE : {self.machine_id.mc_id.machine}'


