# Generated by Django 3.2.16 on 2023-02-05 02:08

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('utilz', '0002_sachetdefectsmodel'),
    ]

    operations = [
        migrations.CreateModel(
            name='SachetAnalysisModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('machine', models.CharField(max_length=3)),
                ('date', models.DateField(auto_now_add=True)),
                ('shift', models.CharField(choices=[('MORNING', 'MORNING'), ('AFTERNOON', 'AFTERNOON'), ('NIGHT', 'NIGHT'), ('DAY', 'DAY')], max_length=12)),
                ('product', models.CharField(max_length=30)),
                ('product_size', models.CharField(max_length=12)),
                ('blend_number', models.CharField(max_length=12)),
                ('inspector', models.CharField(max_length=30)),
                ('product_analyst', models.CharField(max_length=30)),
                ('supervisor', models.CharField(blank=True, max_length=30, null=True)),
                ('status', models.CharField(choices=[('CREATED', 'CREATED'), ('ANALYSED', 'ANALYSED'), ('CHECKED', 'CHECKED'), ('APPROVED', 'APPROVED')], default='CREATED', max_length=12)),
                ('comment', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='SachetFaultModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hour', models.CharField(choices=[('00', '00'), ('01', '01'), ('02', '02'), ('03', '03'), ('04', '04'), ('05', '05'), ('06', '06'), ('07', '07'), ('08', '08'), ('09', '09'), ('10', '10'), ('11', '11'), ('12', '12'), ('13', '13'), ('14', '14'), ('15', '15'), ('16', '16'), ('17', '17'), ('18', '18'), ('19', '19'), ('20', '20'), ('21', '21'), ('22', '22'), ('23', '23')], max_length=6)),
                ('fault', models.TextField()),
                ('corrective_action', models.TextField(blank=True, null=True)),
                ('result', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('machine_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fault', to='sachet_analysis.sachetanalysismodel')),
            ],
        ),
        migrations.CreateModel(
            name='SachetDefectModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hour', models.CharField(choices=[('00', '00'), ('01', '01'), ('02', '02'), ('03', '03'), ('04', '04'), ('05', '05'), ('06', '06'), ('07', '07'), ('08', '08'), ('09', '09'), ('10', '10'), ('11', '11'), ('12', '12'), ('13', '13'), ('14', '14'), ('15', '15'), ('16', '16'), ('17', '17'), ('18', '18'), ('19', '19'), ('20', '20'), ('21', '21'), ('22', '22'), ('23', '23')], max_length=6)),
                ('defect_cause', models.CharField(choices=[('RAW MATERIAL', 'RAW MATERIAL'), ('ENGINEERING', 'ENGINEERING'), ('MAINTENANCE SETTING', 'MAINTENANCE SETTING'), ('HUMAN', 'HUMAN')], max_length=24)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('defect_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='defect', to='utilz.sachetdefectsmodel')),
                ('machine_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='defect', to='sachet_analysis.sachetanalysismodel')),
            ],
        ),
        migrations.CreateModel(
            name='SachetAnalysisWorkFlowModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('analysed_by', models.CharField(blank=True, max_length=24, null=True)),
                ('analysed_comment', models.TextField(blank=True, null=True)),
                ('analysed_datetime', models.DateTimeField(blank=True, null=True)),
                ('checked_by', models.CharField(blank=True, max_length=24, null=True)),
                ('checked_comment', models.TextField(blank=True, null=True)),
                ('checked_datetime', models.DateTimeField(blank=True, null=True)),
                ('approved_by', models.CharField(blank=True, max_length=24, null=True)),
                ('approved_comment', models.TextField(blank=True, null=True)),
                ('approved_datetime', models.DateTimeField(blank=True, null=True)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('machine_id', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='workflow', to='sachet_analysis.sachetanalysismodel')),
            ],
        ),
        migrations.CreateModel(
            name='SachetAlcModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hour', models.CharField(choices=[('00', '00'), ('01', '01'), ('02', '02'), ('03', '03'), ('04', '04'), ('05', '05'), ('06', '06'), ('07', '07'), ('08', '08'), ('09', '09'), ('10', '10'), ('11', '11'), ('12', '12'), ('13', '13'), ('14', '14'), ('15', '15'), ('16', '16'), ('17', '17'), ('18', '18'), ('19', '19'), ('20', '20'), ('21', '21'), ('22', '22'), ('23', '23')], max_length=6)),
                ('taste', models.CharField(choices=[('OKAY', 'OKAY'), ('NOT OKAY', 'NOT OKAY'), ('OTHER', 'OTHER')], max_length=9)),
                ('color', models.FloatField(blank=True, null=True)),
                ('conductivity', models.FloatField()),
                ('ph', models.FloatField()),
                ('alcoholic_strength', models.FloatField()),
                ('volume', models.FloatField()),
                ('clarity', models.IntegerField(default=0)),
                ('weight', models.FloatField()),
                ('case_stamp_code', models.CharField(max_length=24)),
                ('comment', models.TextField()),
                ('machine_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='hourly', to='sachet_analysis.sachetanalysismodel')),
            ],
        ),
    ]
