from django.forms import ModelForm
from .models import SachetAnalysisModel, SachetFaultModel, SachetDefectModel, SachetAnalysisWorkFlowModel, SachetAnalysisFilesModel
from .models_analysis import SachetAlcModel
from utilz.models import ProductsModel, SachetModel



""" SACHET ANALYSIS FORM """
class SachetAnalysisForm(ModelForm):
    def __init__(self,*args,**kwargs):
        super (SachetAnalysisForm ,self ).__init__(*args,**kwargs) # populates the post
        self.fields['product_id'].queryset = ProductsModel.objects.filter(product_section="SACHET")
        self.fields['mc_id'].queryset = SachetModel.objects.all()

    class Meta:
        model = SachetAnalysisModel
        #fields = ['pub_date', 'headline', 'content', 'reporter']
        exclude = ['status', 'datetime_created', 'created_by']

""" SACHET ANALYSIS FAULT FORM """
class SachetFaultForm(ModelForm):
    class Meta:
        model = SachetFaultModel
        exclude = ['machine_id', 'datetime_created', 'created_by']


""" SACHET ANALYSIS FAULT UPDATE FORM """
class SachetFaultUpdateForm(ModelForm):
    class Meta:
        model = SachetFaultModel
        exclude = ['machine_id', 'hour', 'datetime_created', 'created_by']


""" SACHET ANALYSIS DEFECT FORM """
class SachetDefectForm(ModelForm):
    class Meta:
        model = SachetDefectModel
        exclude = ['machine_id', 'hour', 'datetime_created', 'created_by']



""" SACHET ANALYSIS HOURLY ALCOHOLIC FORM """
class SachetAlcoholicAnalysisForm(ModelForm):
    class Meta:
        model = SachetAlcModel
        exclude = ['machine_id', 'datetime_created', 'created_by']



""" SACHET ANALYSIS HOURLY ALCOHOLIC UPDATE FORM """
class SachetAlcoholicAnalysisUpdateForm(ModelForm):
    class Meta:
        model = SachetAlcModel
        exclude = ['machine_id', 'hour', 'datetime_created', 'created_by']



""" SUBMIT SACHET FORM WORKFLOW FORM """
class SachetAnalysisSubmitWorkflowForm(ModelForm):
    class Meta:
        model = SachetAnalysisWorkFlowModel
        fields = ['analysed_comment']

    
""" CHECK LINE ANALYSIS WORKFLOW FORM """
class SachetAnalysisCheckWorkflowForm(ModelForm):
    class Meta:
        model = SachetAnalysisWorkFlowModel
        fields = ['checked_comment']


""" APPROVAL LINE ANALYSIS WORKFLOW FORM """
class SachetAnalysisApprovalWorkflowForm(ModelForm):
    class Meta:
        model = SachetAnalysisWorkFlowModel
        fields = ['approved_comment']



""" FILES UPLOAD FORM """
from django import forms
from typing import Any
class SachetAnalysisFilesModelForm(forms.ModelForm):    
    file = forms.FileField(widget=forms.FileInput(attrs={"class": "col-12 form-control mb-3"}))
    class Meta:
        model = SachetAnalysisFilesModel
        fields = ['file']

        def __init__(self, *args: Any, **kwargs: Any) -> None:
            super(SachetAnalysisFilesModelForm, self).__init__(*args, **kwargs)

            self.fields['file'].help_text = None