from django.http.response import JsonResponse
from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth.decorators import login_required

from line_analysis.models import LineAnalysisModel
from line_inspection.models import LineInspectionModel
from sachet_analysis.models import SachetAnalysisModel
from sachet_inspection.models import SachetInspectionModel


@login_required(login_url='/login')
def report_excel_download(request):
    template_name = 'report_excel_download.html'
    context = {}
    return render(request, template_name, context)


@login_required(login_url='/login')
def report_to_excel_download_api(request):
    fro = request.GET.get('from')
    too = request.GET.get('to')
    #modell = request.GET.get('model')

    data = []
    data.append(list(LineAnalysisModel.objects.filter(date__range=[fro, too]).values()))
    data.append(list(SachetAnalysisModel.objects.filter(date__range=[fro, too]).values()))
    data.append(list(LineInspectionModel.objects.filter(date__range=[fro, too]).values()))
    data.append(list(SachetInspectionModel.objects.filter(date__range=[fro, too]).values()))

    return JsonResponse(data, safe=False)


""" HOURLY DATA TO EXCEL ========================================================= """
from line_analysis.models_analysis import LineAlcModel, LineNonAlcModel
from line_inspection.models_analysis import LineInspectionAlcModel, LineInspectionNonAlcModel
from sachet_analysis.models_analysis import SachetAlcModel
from sachet_inspection.models_analysis import SachetInspectionAlcModel

@login_required(login_url='/login')
def hourly_report_excel_download(request):
    template_name = 'hourly_report_excel_download.html'
    context = {}
    return render(request, template_name, context)


@login_required(login_url='/login')
def hourly_report_to_excel_download_api(request):
    fro = request.GET.get('from')
    too = request.GET.get('to')

    la1 = LineAlcModel.objects.select_related('line_id').filter(line_id__date__range=[fro, too])
    dict_la1 = list(la1.values())
    for key, l in enumerate(la1):
        dict_la1[key]['line'] = l.line_id.line
        dict_la1[key]['product'] = f'{l.line_id.product} / {l.line_id.product_size}'
        dict_la1[key]['date'] = l.line_id.date
        dict_la1[key]['shift'] = l.line_id.shift
        dict_la1[key]['blend_number'] = l.line_id.blend_number
        dict_la1[key]['washing_method'] = l.line_id.washing_method
        dict_la1[key]['inspector'] = l.line_id.inspector
        dict_la1[key]['product_analyst'] = l.line_id.product_analyst
        dict_la1[key]['supervisor'] = l.line_id.supervisor
    la2 = LineNonAlcModel.objects.select_related('line_id').filter(line_id__date__range=[fro, too])
    dict_la2 = list(la2.values())
    for key, l in enumerate(la2):
        dict_la2[key]['line'] = l.line_id.line
        dict_la2[key]['product'] = f'{l.line_id.product} / {l.line_id.product_size}'
        dict_la2[key]['date'] = l.line_id.date
        dict_la2[key]['shift'] = l.line_id.shift
        dict_la2[key]['blend_number'] = l.line_id.blend_number
        dict_la2[key]['washing_method'] = l.line_id.washing_method
        dict_la2[key]['inspector'] = l.line_id.inspector
        dict_la2[key]['product_analyst'] = l.line_id.product_analyst
        dict_la2[key]['supervisor'] = l.line_id.supervisor
    li1 = LineInspectionAlcModel.objects.select_related('line_id').filter(line_id__date__range=[fro, too])
    dict_li1 = list(li1.values())
    for key, l in enumerate(li1):
        dict_li1[key]['line'] = l.line_id.l_id.line
        dict_li1[key]['product'] = f'{l.line_id.product_id.product_name} / {l.line_id.product_id.product_size}'
        dict_li1[key]['date'] = l.line_id.date
        dict_li1[key]['shift'] = l.line_id.shift
        dict_li1[key]['blend_number'] = l.line_id.blend_number
        dict_li1[key]['washing_method'] = l.line_id.washing_method
        dict_li1[key]['inspector'] = l.line_id.inspector
        dict_li1[key]['supervisor'] = l.line_id.supervisor
        dict_li1[key]['foreman'] = l.line_id.foreman
    li2 = LineInspectionNonAlcModel.objects.select_related('line_id').filter(line_id__date__range=[fro, too])
    dict_li2 = list(li2.values())
    for key, l in enumerate(li2):
        dict_li2[key]['line'] = l.line_id.l_id.line
        dict_li2[key]['product'] = f'{l.line_id.product_id.product_name} / {l.line_id.product_id.product_size}'
        dict_li2[key]['date'] = l.line_id.date
        dict_li2[key]['shift'] = l.line_id.shift
        dict_li2[key]['blend_number'] = l.line_id.blend_number
        dict_li2[key]['washing_method'] = l.line_id.washing_method
        dict_li2[key]['inspector'] = l.line_id.inspector
        dict_li2[key]['supervisor'] = l.line_id.supervisor
        dict_li2[key]['foreman'] = l.line_id.foreman
    sa = SachetAlcModel.objects.select_related('machine_id').filter(machine_id__date__range=[fro, too])
    dict_sa = list(sa.values())
    for key, l in enumerate(sa):
        dict_sa[key]['machine'] = l.machine_id.mc_id.machine
        dict_sa[key]['product'] = f'{l.machine_id.product_id.product_name} / {l.machine_id.product_id.product_size}'
        dict_sa[key]['date'] = l.machine_id.date
        dict_sa[key]['shift'] = l.machine_id.shift
        dict_sa[key]['blend_number'] = l.machine_id.blend_number
        dict_sa[key]['inspector'] = l.machine_id.inspector
        dict_sa[key]['product_analyst'] = l.machine_id.product_analyst
        dict_sa[key]['supervisor'] = l.machine_id.supervisor
    si = SachetInspectionAlcModel.objects.select_related('machine_id').filter(machine_id__date__range=[fro, too])
    dict_si = list(si.values())
    for key, l in enumerate(si):
        dict_si[key]['machine'] = l.machine_id.mc_id.machine
        dict_si[key]['product'] = f'{l.machine_id.product_id.product_name} / {l.machine_id.product_id.product_size}'
        dict_si[key]['date'] = l.machine_id.date
        dict_si[key]['shift'] = l.machine_id.shift
        dict_si[key]['blend_number'] = l.machine_id.blend_number
        dict_si[key]['inspector'] = l.machine_id.inspector
        dict_si[key]['supervisor'] = l.machine_id.supervisor
        dict_si[key]['foreman'] = l.machine_id.foreman
        dict_si[key]['machine_operators'] = l.machine_id.machine_operators
        dict_si[key]['packers'] = l.machine_id.packers
    data = []

    
    data.append(dict_la1)
    data.append(dict_la2)
    data.append(dict_li1)
    data.append(dict_li2)
    data.append(dict_sa)
    data.append(dict_si)

    return JsonResponse(data, safe=False)
