from django.db import models
from .models import LineInspectionModel, HOUR_CHOICE

SELECTION_CHOICE = (("OKAY", "OKAY"), ("NOT OKAY", "NOT OKAY"), ("OTHER", "OTHER"))

class LineInspectionAlcModel(models.Model):
    line_id = models.ForeignKey(LineInspectionModel, related_name='hourly', on_delete=models.CASCADE)
    hour = models.CharField(max_length= 6, choices=HOUR_CHOICE)
    taste = models.CharField(max_length= 9, choices=SELECTION_CHOICE)
    clarity = models.IntegerField(default=0)
    bottle_defect = models.IntegerField(default=0)
    cap_defect = models.IntegerField(default=0)
    label_defect = models.IntegerField(default=0)
    shrink_wrapping_defect = models.IntegerField(default=0)
    case_stamp_code = models.CharField(max_length= 24)

    nylon_code = models.CharField(max_length=24, null=True, blank=True)
    cap_code = models.CharField(max_length=24, null=True, blank=True)
    label_code = models.CharField(max_length=24, null=True, blank=True)
    bottle_code = models.CharField(max_length=24, null=True, blank=True)
    case_code = models.CharField(max_length=24, null=True, blank=True)

    sighter1 = models.CharField(max_length=24)
    sighter2 = models.CharField(max_length=24)

    comment = models.TextField(null=True, blank=True)

    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'LINE ALCOHOLIC HOURLY INSPECTION'
         ordering = ('line_id__date', 'line_id__shift', 'line_id__l_id__line', 'hour')

    def __str__(self) -> str:
        return f'HOUR : {self.hour}, DATE : {self.line_id.date}, LINE : {self.line_id.l_id.line}'



class LineInspectionNonAlcModel(models.Model):
    line_id = models.ForeignKey(LineInspectionModel, related_name='hourly1', on_delete=models.CASCADE)
    hour = models.CharField(max_length= 6, choices=HOUR_CHOICE)
    taste = models.CharField(max_length= 9, choices=SELECTION_CHOICE)
    
    temp_of_ex_heat_exchanger = models.FloatField()
    temp_guage_carbonator = models.FloatField()
    co2_pressure_guage = models.FloatField()
    temp_ex_filling_machine = models.FloatField()
    co2_product_before_past = models.FloatField()
    pre_pasteurization_temp = models.FloatField()
    pasteurization_temp = models.FloatField()
    co2_product_after_past = models.FloatField()

    bottle_rinsing_defect = models.IntegerField(default=0)
    clarity = models.IntegerField(default=0)
    bottle_defect = models.IntegerField(default=0)
    cork_cap_defect = models.IntegerField(default=0)
    foil_defect = models.IntegerField(default=0)
    wire_hooding_defect = models.IntegerField(default=0)
    label_defect = models.IntegerField(default=0)

    wire_hood_code = models.CharField(max_length=24, null=True, blank=True)
    corking_cap_code = models.CharField(max_length=24, null=True, blank=True)
    label_code = models.CharField(max_length=50, null=True, blank=True)
    bottle_code = models.CharField(max_length=24, null=True, blank=True)
    case_code = models.CharField(max_length=24, null=True, blank=True)

    is_batch_number_correct = models.CharField(max_length= 9, choices=SELECTION_CHOICE)
    is_best_before_correct = models.CharField(max_length= 9, choices=SELECTION_CHOICE)
    case_stamp_code = models.CharField(max_length=24)
    environment = models.CharField(max_length= 9, choices=SELECTION_CHOICE)

    sighter1 = models.CharField(max_length=24)
    sighter2 = models.CharField(max_length=24)
    sighter3 = models.CharField(max_length=24)
    sighter4 = models.CharField(max_length=24)

    comment = models.TextField(null=True, blank=True)

    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'LINE NON-ALCOHOLIC HOURLY INSPECTION'
         ordering = ('line_id__date', 'line_id__shift', 'line_id__l_id__line', 'hour')

    def __str__(self) -> str:
        return f'HOUR : {self.hour}, DATE : {self.line_id.date}, MACHINE : {self.line_id.l_id.line}'


