# Generated by Django 3.2.16 on 2023-02-22 04:47

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('utilz', '0006_alter_productsmodel_product_type'),
    ]

    operations = [
        migrations.CreateModel(
            name='LineInspectionModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date', models.DateField(default=django.utils.timezone.now)),
                ('shift', models.CharField(choices=[('MORNING', 'MORNING'), ('AFTERNOON', 'AFTERNOON'), ('NIGHT', 'NIGHT'), ('DAY', 'DAY')], max_length=12)),
                ('blend_number', models.CharField(max_length=24)),
                ('washing_method', models.CharField(max_length=24)),
                ('inspector', models.CharField(max_length=30)),
                ('supervisor', models.CharField(blank=True, max_length=30, null=True)),
                ('foreman', models.CharField(max_length=30)),
                ('status', models.CharField(choices=[('CREATED', 'CREATED'), ('ANALYSED', 'ANALYSED'), ('CHECKED', 'CHECKED'), ('APPROVED', 'APPROVED')], default='CREATED', max_length=12)),
                ('comment', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('l_id', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='line_insp', to='utilz.linesmodel')),
                ('product_id', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='product_insp', to='utilz.productsmodel')),
            ],
            options={
                'verbose_name_plural': 'LINE INSPECTION SHIFT FORM',
                'ordering': ('date', 'shift', 'l_id__line'),
            },
        ),
        migrations.CreateModel(
            name='LineInspectionWorkFlowModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('analysed_by', models.CharField(blank=True, max_length=24, null=True)),
                ('analysed_comment', models.TextField(blank=True, null=True)),
                ('analysed_datetime', models.DateTimeField(blank=True, null=True)),
                ('checked_by', models.CharField(blank=True, max_length=24, null=True)),
                ('checked_comment', models.TextField(blank=True, null=True)),
                ('checked_datetime', models.DateTimeField(blank=True, null=True)),
                ('approved_by', models.CharField(blank=True, max_length=24, null=True)),
                ('approved_comment', models.TextField(blank=True, null=True)),
                ('approved_datetime', models.DateTimeField(blank=True, null=True)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('line_id', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='workflow', to='line_inspection.lineinspectionmodel')),
            ],
            options={
                'verbose_name_plural': 'LINE INSPECTION SHIFT WORKFLOW',
                'ordering': ('line_id__date', 'line_id__shift', 'line_id__l_id__line'),
            },
        ),
        migrations.CreateModel(
            name='LineInspectiontDefectModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hour', models.CharField(choices=[('00', '00'), ('01', '01'), ('02', '02'), ('03', '03'), ('04', '04'), ('05', '05'), ('06', '06'), ('07', '07'), ('08', '08'), ('09', '09'), ('10', '10'), ('11', '11'), ('12', '12'), ('13', '13'), ('14', '14'), ('15', '15'), ('16', '16'), ('17', '17'), ('18', '18'), ('19', '19'), ('20', '20'), ('21', '21'), ('22', '22'), ('23', '23')], max_length=6)),
                ('quantity', models.IntegerField()),
                ('defect_cause', models.CharField(choices=[('RAW MATERIAL', 'M : RAW MATERIAL'), ('ENGINEERING', 'E : ENGINEERING'), ('MAINTENANCE SETTING', 'W : MAINTENANCE SETTING'), ('HUMAN', 'O : HUMAN')], max_length=24)),
                ('comment', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('defect_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='defect_insp', to='utilz.sachetdefectsmodel')),
                ('line_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='defect', to='line_inspection.lineinspectionmodel')),
            ],
            options={
                'verbose_name_plural': 'LINE INSPECTION DEFECT RECORD',
                'ordering': ('line_id__date', 'line_id__shift', 'line_id__l_id__line', 'hour'),
            },
        ),
        migrations.CreateModel(
            name='LineInspectionNonAlcModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hour', models.CharField(choices=[('00', '00'), ('01', '01'), ('02', '02'), ('03', '03'), ('04', '04'), ('05', '05'), ('06', '06'), ('07', '07'), ('08', '08'), ('09', '09'), ('10', '10'), ('11', '11'), ('12', '12'), ('13', '13'), ('14', '14'), ('15', '15'), ('16', '16'), ('17', '17'), ('18', '18'), ('19', '19'), ('20', '20'), ('21', '21'), ('22', '22'), ('23', '23')], max_length=6)),
                ('taste', models.CharField(choices=[('OKAY', 'OKAY'), ('NOT OKAY', 'NOT OKAY'), ('OTHER', 'OTHER')], max_length=9)),
                ('temp_of_ex_heat_exchanger', models.FloatField()),
                ('temp_guage_carbonator', models.FloatField()),
                ('co2_pressure_guage', models.FloatField()),
                ('temp_ex_filling_machine', models.FloatField()),
                ('co2_product_before_past', models.FloatField()),
                ('pre_pasteurization_temp', models.FloatField()),
                ('pasteurization_temp', models.FloatField()),
                ('co2_product_after_past', models.FloatField()),
                ('bottle_rinsing_defect', models.IntegerField(default=0)),
                ('clarity', models.IntegerField(default=0)),
                ('bottle_defect', models.IntegerField(default=0)),
                ('cork_cap_defect', models.IntegerField(default=0)),
                ('foil_defect', models.IntegerField(default=0)),
                ('wire_hooding_defect', models.IntegerField(default=0)),
                ('label_defect', models.IntegerField(default=0)),
                ('wire_hood_code', models.CharField(blank=True, max_length=24, null=True)),
                ('corking_cap_code', models.CharField(blank=True, max_length=24, null=True)),
                ('label_code', models.CharField(blank=True, max_length=50, null=True)),
                ('bottle_code', models.CharField(blank=True, max_length=24, null=True)),
                ('is_batch_number_correct', models.CharField(choices=[('OKAY', 'OKAY'), ('NOT OKAY', 'NOT OKAY'), ('OTHER', 'OTHER')], max_length=9)),
                ('is_best_before_correct', models.CharField(choices=[('OKAY', 'OKAY'), ('NOT OKAY', 'NOT OKAY'), ('OTHER', 'OTHER')], max_length=9)),
                ('case_code', models.CharField(max_length=24)),
                ('environment', models.CharField(choices=[('OKAY', 'OKAY'), ('NOT OKAY', 'NOT OKAY'), ('OTHER', 'OTHER')], max_length=9)),
                ('sighter1', models.CharField(max_length=24)),
                ('sighter2', models.CharField(max_length=24)),
                ('sighter3', models.CharField(max_length=24)),
                ('sighter4', models.CharField(max_length=24)),
                ('comment', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('line_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='hourly1', to='line_inspection.lineinspectionmodel')),
            ],
            options={
                'verbose_name_plural': 'LINE NON-ALCOHOLIC HOURLY INSPECTION',
                'ordering': ('line_id__date', 'line_id__shift', 'line_id__l_id__line', 'hour'),
            },
        ),
        migrations.CreateModel(
            name='LineInspectionFilesModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(blank=True, null=True, upload_to='files_folder', validators=[django.core.validators.FileExtensionValidator(['png', 'jpg', 'jpeg', 'pdf', 'doc', 'docx', 'cdr'])])),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('line_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='files', to='line_inspection.lineinspectionmodel')),
            ],
            options={
                'verbose_name_plural': 'LINE INSPECTION UPLOADED FILES',
                'ordering': ('line_id__date', 'line_id__shift', 'line_id__l_id__line'),
            },
        ),
        migrations.CreateModel(
            name='LineInspectionFaultModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hour', models.CharField(choices=[('00', '00'), ('01', '01'), ('02', '02'), ('03', '03'), ('04', '04'), ('05', '05'), ('06', '06'), ('07', '07'), ('08', '08'), ('09', '09'), ('10', '10'), ('11', '11'), ('12', '12'), ('13', '13'), ('14', '14'), ('15', '15'), ('16', '16'), ('17', '17'), ('18', '18'), ('19', '19'), ('20', '20'), ('21', '21'), ('22', '22'), ('23', '23')], max_length=6)),
                ('fault', models.TextField()),
                ('corrective_action', models.TextField(blank=True, null=True)),
                ('result', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('line_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fault', to='line_inspection.lineinspectionmodel')),
            ],
            options={
                'verbose_name_plural': 'LINE INSPECTION FAULT BOX',
                'ordering': ('line_id__date', 'line_id__shift', 'line_id__l_id__line', 'hour'),
            },
        ),
        migrations.CreateModel(
            name='LineInspectionAlcModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hour', models.CharField(choices=[('00', '00'), ('01', '01'), ('02', '02'), ('03', '03'), ('04', '04'), ('05', '05'), ('06', '06'), ('07', '07'), ('08', '08'), ('09', '09'), ('10', '10'), ('11', '11'), ('12', '12'), ('13', '13'), ('14', '14'), ('15', '15'), ('16', '16'), ('17', '17'), ('18', '18'), ('19', '19'), ('20', '20'), ('21', '21'), ('22', '22'), ('23', '23')], max_length=6)),
                ('taste', models.CharField(choices=[('OKAY', 'OKAY'), ('NOT OKAY', 'NOT OKAY'), ('OTHER', 'OTHER')], max_length=9)),
                ('clarity', models.IntegerField(default=0)),
                ('bottle_defect', models.IntegerField(default=0)),
                ('cap_defect', models.IntegerField(default=0)),
                ('label_defect', models.IntegerField(default=0)),
                ('shrink_wrapping_defect', models.IntegerField(default=0)),
                ('nylon_code', models.CharField(max_length=24)),
                ('cap_code', models.CharField(max_length=24)),
                ('label_code', models.CharField(max_length=24)),
                ('bottle_code', models.CharField(max_length=24)),
                ('case_code', models.CharField(max_length=24)),
                ('sighter1', models.CharField(max_length=24)),
                ('sighter2', models.CharField(max_length=24)),
                ('comment', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('line_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='hourly', to='line_inspection.lineinspectionmodel')),
            ],
            options={
                'verbose_name_plural': 'LINE ALCOHOLIC HOURLY INSPECTION',
                'ordering': ('line_id__date', 'line_id__shift', 'line_id__l_id__line', 'hour'),
            },
        ),
    ]
