from django.forms import ModelForm
from .models import LineInspectionModel, LineInspectionFaultModel, LineInspectiontDefectModel, LineInspectionDespatchPalletModel, LineInspectionWorkFlowModel, LineInspectionFilesModel
from .models_analysis import LineInspectionAlcModel, LineInspectionNonAlcModel
from utilz.models import ProductsModel, LinesModel



""" LINE INSPECTION FORM """
class LineInspectionForm(ModelForm):
    def __init__(self,*args,**kwargs):
        super (LineInspectionForm ,self ).__init__(*args,**kwargs) # populates the post
        self.fields['product_id'].queryset = ProductsModel.objects.filter(product_section="LINE")
        self.fields['l_id'].queryset = LinesModel.objects.all()

    class Meta:
        model = LineInspectionModel
        #fields = ['pub_date', 'headline', 'content', 'reporter']
        exclude = ['status', 'datetime_created', 'created_by']


""" LINE INSPECTION UPDATE FORM """
class LineInspectionUpdateForm(ModelForm):
    def __init__(self,*args,**kwargs):
        super (LineInspectionUpdateForm ,self ).__init__(*args,**kwargs) # populates the post
        self.fields['product_id'].queryset = ProductsModel.objects.filter(product_section="LINE")

    class Meta:
        model = LineInspectionModel
        #fields = ['pub_date', 'headline', 'content', 'reporter']
        exclude = ['l_id', 'date', 'status', 'datetime_created', 'created_by']


""" LINE INSPECTION FAULT FORM """
class LineInspectionFaultForm(ModelForm):
    class Meta:
        model = LineInspectionFaultModel
        exclude = ['line_id', 'datetime_created', 'created_by']


""" LINE INSPECTION FAULT UPDATE FORM """
class LineInspectionFaultUpdateForm(ModelForm):
    class Meta:
        model = LineInspectionFaultModel
        exclude = ['line_id', 'hour', 'datetime_created', 'created_by']


""" LINE INSPECTION DEFECT FORM """
class LineInspectiontDefectForm(ModelForm):
    class Meta:
        model = LineInspectiontDefectModel
        exclude = ['line_id', 'hour', 'datetime_created', 'created_by']



""" LINE INSPECTION HOURLY ALCOHOLIC FORM """
class LineInspectionAlcoholicForm(ModelForm):
    class Meta:
        model = LineInspectionAlcModel
        exclude = ['line_id', 'datetime_created', 'created_by']



""" LINE INSPECTION HOURLY ALCOHOLIC UPDATE FORM """
class LineInspectionAlcoholicUpdateForm(ModelForm):
    class Meta:
        model = LineInspectionAlcModel
        exclude = ['line_id', 'hour', 'datetime_created', 'created_by']



""" LINE INSPECTION HOURLY ALCOHOLIC FORM """
class LineInspectionNonAlcoholicForm(ModelForm):
    class Meta:
        model = LineInspectionNonAlcModel
        exclude = ['line_id', 'datetime_created', 'created_by']



""" LINE INSPECTION HOURLY ALCOHOLIC UPDATE FORM """
class LineInspectionNonAlcoholicUpdateForm(ModelForm):
    class Meta:
        model = LineInspectionNonAlcModel
        exclude = ['line_id', 'hour', 'datetime_created', 'created_by']



""" LINE INSPECTION DESPATCHED PRODUCT """
class LineInspectionDespatchPalletForm(ModelForm):
    class Meta:
        model = LineInspectionDespatchPalletModel
        exclude = ['line_id', 'datetime_created', 'created_by']



""" SUBMIT LINE INSPECTION FORM WORKFLOW FORM """
class LineInspectionSubmitWorkflowForm(ModelForm):
    class Meta:
        model = LineInspectionWorkFlowModel
        fields = ['analysed_comment']

    
""" CHECK LINE INSPECTION WORKFLOW FORM """
class LineInspectionCheckWorkflowForm(ModelForm):
    class Meta:
        model = LineInspectionWorkFlowModel
        fields = ['checked_comment']


""" APPROVAL LINE INSPECTION WORKFLOW FORM """
class LineInspectionApprovalWorkflowForm(ModelForm):
    class Meta:
        model = LineInspectionWorkFlowModel
        fields = ['approved_comment']



""" FILES UPLOAD FORM """
from django import forms
from typing import Any
class LineInspectionFilesModelForm(forms.ModelForm):    
    file = forms.FileField(widget=forms.FileInput(attrs={"class": "col-12 form-control mb-3"}))
    class Meta:
        model = LineInspectionFilesModel
        fields = ['file']

        def __init__(self, *args: Any, **kwargs: Any) -> None:
            super(LineInspectionFilesModelForm, self).__init__(*args, **kwargs)

            self.fields['file'].help_text = None