from django.http.response import JsonResponse
from django.shortcuts import render, redirect, get_object_or_404
from django.contrib.auth.decorators import login_required
from django.utils import timezone
from django.contrib import messages
from .models import LineAnalysisModel, LineFaultModel, LineAnalysisWorkFlowModel
from .models_analysis import LineAlcModel, LineNonAlcModel
from .forms import LineAnalysisForm, LineAnalysisWorkflowForm, LineCheckWorkflowForm, LineApprovalWorkflowForm
from utilz.models import ProductsModel, LinesModel
from django.views.decorators.cache import cache_page
from utilz.fxns import set_case_code, set_shift_analysis_table
from accounts.fxns import user_activity





""" SUBMIT ANALYSIS FORM WORKFLOW """
@login_required(login_url='/login')
def line_analysis_workflow_submit(request, pk):

    query = get_object_or_404(LineAnalysisWorkFlowModel, pk=pk)

    if request.method == 'POST':
        
        form = LineAnalysisWorkflowForm(request.POST, instance=query)
        if form.is_valid():
            obj = form.save(commit=False)
            obj.analysed_by = request.user.username
            obj.analysed_datetime = timezone.now()
            obj.save()

            query.line_id.status = 'ANALYSED'
            query.line_id.save()

            """ USER ACTIVITY """
            user_activity(request, model_name='LINE_ANALYSIS', model_id=query.line_id.id, activity='SUBMIT', description=f"Line {query.line_id.line} Analysis form Submitted")

            messages.success(request, 'Form submitted successfully')
            return redirect(f'/line/analysis/detail/{query.line_id.id}/')
        messages.error(request, 'Network Error, form not submitted!!!')
        return redirect(f'/line/analysis/detail/{query.line_id.id}/')
    messages.error(request, 'Method not allowed!!!')
    return redirect(f'/line/analysis/detail/{query.line_id.id}/')



""" CHECK ANALYSIS FORM WORKFLOW """
@login_required(login_url='/login')
def line_analysis_workflow_check(request, pk):

    query = get_object_or_404(LineAnalysisWorkFlowModel, pk=pk)

    if request.method == 'POST':
        form = LineCheckWorkflowForm(request.POST, instance=query)
        if form.is_valid():
            obj = form.save(commit=False)
            obj.checked_by = request.user.username
            obj.checked_datetime = timezone.now()
            obj.save()

            query.line_id.status = 'CHECKED'
            query.line_id.save()

            """ USER ACTIVITY """
            user_activity(request, model_name='LINE_ANALYSIS', model_id=query.line_id.id, activity='CHECK', description=f"Line {query.line_id.line} Analysis form Checked")

            messages.success(request, 'Form checked successfully')
            return redirect(f'/line/analysis/detail/{query.line_id.id}/')
        messages.error(request, 'Network Error, form not checked!!!')
        return redirect(f'/line/analysis/detail/{query.line_id.id}/')
    messages.error(request, 'Method not allowed!!!')
    return redirect(f'/line/analysis/detail/{query.line_id.id}/')




""" APPROVAL ANALYSIS FORM WORKFLOW """
@login_required(login_url='/login')
def line_analysis_workflow_approval(request, pk):

    query = get_object_or_404(LineAnalysisWorkFlowModel, pk=pk)

    if request.method == 'POST':
        form = LineApprovalWorkflowForm(request.POST, instance=query)
        if form.is_valid():
            obj = form.save(commit=False)
            obj.approved_by = request.user.username
            obj.approved_datetime = timezone.now()
            obj.save()

            query.line_id.status = 'APPROVED'
            query.line_id.save()

            """ USER ACTIVITY """
            user_activity(request, model_name='LINE_ANALYSIS', model_id=query.line_id.id, activity='APPROVE', description=f"Line {query.line_id.line} Analysis form Approved")

            messages.success(request, 'Form Approved successfully')
            return redirect(f'/line/analysis/detail/{query.line_id.id}/')
        messages.error(request, 'Network Error, form not Approved!!!')
        return redirect(f'/line/analysis/detail/{query.line_id.id}/')
    messages.error(request, 'Method not allowed!!!')
    return redirect(f'/line/analysis/detail/{query.line_id.id}/')