from django.urls import path
from .views import line_analysis, line_analysis_detail, line_analysis_delete, line_analysis_hourly, line_analysis_create_fault, line_analysis_form, file_upload, file_delete
from .views_analysis import line_analysis_hourly_detail, line_analysis_hourly_delete, line_analysis_fault_detail, line_analysis_fault_delete
from .views_workflow import line_analysis_workflow_submit, line_analysis_workflow_check, line_analysis_workflow_approval


""" line/analysis """
urlpatterns = [
    path('', line_analysis),
    path('detail/<int:pk>/', line_analysis_detail),
    path('delete/<int:pk>/', line_analysis_delete),
    path('analysis/<int:pk>/', line_analysis_hourly), #CREATE HOURLY ANALYSIS
    path('analysis/delete/<int:pk>/', line_analysis_hourly_delete), #DELETE HOURLY ANALYSIS

    path('hour/<int:form_pk>/<int:hour_pk>/', line_analysis_hourly_detail), ## VIEW DETAILS OF HOURLY ANALYSIS
    
    path('create_fault/<int:pk>/', line_analysis_create_fault), ## CREATE HOURLY FAULT
    path('fault/<int:pk>/', line_analysis_fault_detail), ## CREATE HOURLY FAULT
    path('fault/delete/<int:pk>/', line_analysis_fault_delete), ## CREATE HOURLY FAULT

    path('submit/<int:pk>/', line_analysis_workflow_submit),
    path('check/<int:pk>/', line_analysis_workflow_check),
    path('approve/<int:pk>/', line_analysis_workflow_approval),

    path('form/<int:pk>/', line_analysis_form),

    path('file/upload/<int:pk>/', file_upload),
    path('file/delete/<int:pk>/', file_delete)

]
"""
    path('workflow/<int:pk>/', line_workflow_api),
    path('fault/', line_fault_api),
    path('fault/<int:pk>/', line_fault_api),
    path('alc_analysis/', line_alcoholic_api),
    path('alc_analysis/<int:pk>/', line_alcoholic_api),
    path('non_alc_analysis', line_non_alcoholic_api),
    path('non_alc_analysis/<int:pk>/', line_non_alcoholic_api)
    """