from django.db import models
from .models import LineAnalysisModel, HOUR_CHOICE

SELECTION_CHOICE = (("OKAY", "OKAY"), ("NOT OKAY", "NOT OKAY"), ("OTHER", "OTHER"))

class LineAlcModel(models.Model):
    line_id = models.ForeignKey(LineAnalysisModel, related_name='hourly', on_delete=models.CASCADE)
    hour = models.CharField(max_length= 6, choices=HOUR_CHOICE)
    #has_bottling = models.BooleanField(default=False)
    taste = models.CharField(max_length= 9, choices=SELECTION_CHOICE)
    color = models.FloatField(null=True, blank=True)
    conductivity = models.FloatField()
    ph = models.FloatField()
    alcoholic_strength = models.FloatField()
    volume = models.FloatField()
    clarity = models.IntegerField(default=0)
    bottle_defect = models.IntegerField(default=0)
    cap_defect = models.IntegerField(default=0)
    label_defect = models.IntegerField(default=0)
    manufacturing_date = models.CharField(max_length= 12)
    batch_number = models.CharField(max_length= 12)
    case_code = models.CharField(max_length= 12)
    comment = models.TextField(null=True, blank=True)

    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'ALCOHOLIC LINE HOURLY ANALYSIS'
         ordering = ('line_id__date', 'line_id__shift', 'line_id__line', 'hour')

    def __str__(self) -> str:
        return f'HOUR : {self.hour}, DATE : {self.line_id.date}, LINE : {self.line_id.line}'



class LineNonAlcModel(models.Model):
    line_id = models.ForeignKey(LineAnalysisModel, related_name='hourly1', on_delete=models.CASCADE)
    hour = models.CharField(max_length= 6, choices=HOUR_CHOICE)
    #has_bottling = models.BooleanField(default=False)
    taste = models.CharField(max_length= 9, choices=SELECTION_CHOICE)
    color = models.FloatField(null=True, blank=True)
    conductivity = models.FloatField()
    ph = models.FloatField()
    co2_level_before_past = models.FloatField()
    co2_level_after_past = models.FloatField()
    volume = models.FloatField()
    clarity = models.IntegerField(default=0)
    bottle_defect = models.IntegerField(default=0)
    corking_caping_defect = models.IntegerField(default=0)
    label_defect = models.IntegerField(default=0)
    manufacturing_date = models.CharField(max_length= 12)
    batch_number = models.CharField(max_length= 12)
    best_before_date = models.CharField(max_length= 12)
    environment = models.CharField(max_length= 9, choices=SELECTION_CHOICE)
    comment = models.TextField(null=True, blank=True)

    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'NON ALCOHOLIC LINE HOURLY ANALYSIS'
         ordering = ('line_id__date', 'line_id__shift', 'line_id__line', 'hour')

    def __str__(self) -> str:
        return f'HOUR : {self.hour}, DATE : {self.line_id.date}, LINE : {self.line_id.line}'

