from django.db import models
from django.utils import timezone
from utilz.models import ProductsModel


SHIFT_CHOICE = (("MORNING", "MORNING"), ("AFTERNOON", "AFTERNOON"), ("NIGHT", "NIGHT"), ("DAY", "DAY"))
STATUS_CHOICE = (('CREATED', 'CREATED'), ('ANALYSED', 'ANALYSED'), ('CHECKED', 'CHECKED'), ('APPROVED', 'APPROVED'))

class LineAnalysisModel(models.Model):
    line = models.CharField(max_length=3)
    date = models.DateField(default=timezone.now)
    shift = models.CharField(max_length=12, choices = SHIFT_CHOICE)
    product = models.CharField(max_length=30)
    product_size = models.CharField(max_length=12)
    blend_number = models.CharField(max_length=12)
    washing_method = models.CharField(max_length=12)
    inspector = models.CharField(max_length=30)
    product_analyst = models.CharField(max_length=30)
    supervisor = models.CharField(max_length=30, null=True, blank=True)
    status = models.CharField(max_length=12, choices = STATUS_CHOICE, default='CREATED')
    comment = models.TextField(null=True, blank=True)

    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         #verbose_name = 'LINE ANALYSIS'
         verbose_name_plural = 'LINE ANALYSIS SHIFT FORM'
         ordering = ('date', 'shift', 'line')

    def get_product_type(self):
        product_type = ProductsModel.objects.filter(product_name=self.product).filter(product_size=self.product_size).first()
        if product_type:
            return product_type.product_type
        else:
            'Not found'


    def __str__(self) -> str:
        return f"DATE : {self.date}, LINE : {self.line}, SHIFT : {self.shift}, PRODUCT : {self.product}"



HOUR_CHOICE = (('00','00'),('01','01'),('02','02'),('03','03'),('04','04'),('05','05'),('06','06'),('07','07'),('08','08'),('09','09'),('10','10'),('11','11'),('12','12'),('13','13'),('14','14'),('15','15'),('16','16'),('17','17'),('18','18'),('19','19'),('20','20'),('21','21'),('22','22'),('23','23'))
class LineFaultModel(models.Model):
    line_id = models.ForeignKey(LineAnalysisModel, related_name='fault', on_delete=models.CASCADE)
    hour = models.CharField(max_length=6, choices= HOUR_CHOICE)
    fault = models.TextField()
    corrective_action = models.TextField(null=True, blank=True)
    result = models.TextField(null=True, blank=True)
    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'LINE ANALYSIS FAULT BOX'
         ordering = ('line_id__date', 'line_id__shift', 'line_id__line')

    def __str__(self) -> str:
        return f"DATE : {self.line_id.date}, LINE : {self.line_id.line}, SHIFT : {self.line_id.shift}"


class LineAnalysisWorkFlowModel(models.Model):
    line_id = models.OneToOneField(LineAnalysisModel, related_name='workflow', on_delete=models.CASCADE)

    analysed_by = models.CharField(max_length=24, null=True, blank=True)
    analysed_comment = models.TextField(null=True, blank=True)
    analysed_datetime = models.DateTimeField(null=True, blank=True)

    checked_by = models.CharField(max_length=24, null=True, blank=True)
    checked_comment = models.TextField(null=True, blank=True)
    checked_datetime = models.DateTimeField(null=True, blank=True)

    approved_by = models.CharField(max_length=24, null=True, blank=True)
    approved_comment = models.TextField(null=True, blank=True)
    approved_datetime = models.DateTimeField(null=True, blank=True)

    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'LINE ANALYSIS SHIFT WORKFLOW'
         ordering = ('line_id__date', 'line_id__shift', 'line_id__line')

    def __str__(self):
        return f'DATE : {self.line_id.date}, LINE : {self.line_id.line}, SHIFT : {self.line_id.shift}'



from django.core.validators import FileExtensionValidator
class LineAnalysisFilesModel(models.Model):
    line_id = models.ForeignKey(LineAnalysisModel, related_name='files', on_delete=models.CASCADE)
    file = models.FileField(validators=[FileExtensionValidator(['png','jpg','jpeg','pdf','doc','docx','cdr'])], upload_to='files_folder', blank=True, null=True)
    created_by = models.CharField(max_length=24)
    datetime_created = models.DateTimeField(auto_now_add=True)

    class Meta:
         verbose_name_plural = 'LINE ANALYSIS UPLOADED FILES'
         ordering = ('line_id__date', 'line_id__shift', 'line_id__line')

    def __str__(self):
        return f'DATE : {self.line_id.date}, LINE : {self.line_id.line}, SHIFT : {self.line_id.shift}'
    

