# Generated by Django 3.2.16 on 2023-02-03 21:14

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='LineAnalysisModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('line', models.CharField(max_length=3)),
                ('date', models.DateField(auto_now_add=True)),
                ('shift', models.CharField(choices=[('MORNING', 'MORNING'), ('AFTERNOON', 'AFTERNOON'), ('NIGHT', 'NIGHT'), ('DAY', 'DAY')], max_length=12)),
                ('product', models.CharField(max_length=30)),
                ('product_size', models.CharField(max_length=12)),
                ('blend_number', models.CharField(max_length=12)),
                ('washing_method', models.CharField(max_length=12)),
                ('inspector', models.CharField(max_length=30)),
                ('product_analyst', models.CharField(max_length=30)),
                ('line_supervisor', models.CharField(blank=True, max_length=30, null=True)),
                ('status', models.CharField(choices=[('CREATED', 'CREATED'), ('ANALYSED', 'ANALYSED'), ('CHECKED', 'CHECKED'), ('APPROVED', 'APPROVED')], default='CREATED', max_length=12)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='LineWorkFlowModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('analysed_by', models.CharField(blank=True, max_length=24, null=True)),
                ('analysed_comment', models.TextField(blank=True, null=True)),
                ('analysed_datetime', models.DateTimeField(blank=True, null=True)),
                ('checked_by', models.CharField(blank=True, max_length=24, null=True)),
                ('checked_comment', models.TextField(blank=True, null=True)),
                ('checked_datetime', models.DateTimeField(blank=True, null=True)),
                ('approved_by', models.CharField(blank=True, max_length=24, null=True)),
                ('approved_comment', models.TextField(blank=True, null=True)),
                ('approved_datetime', models.DateTimeField(blank=True, null=True)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('line_id', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='workflow', to='line_analysis.lineanalysismodel')),
            ],
        ),
        migrations.CreateModel(
            name='LineFaultModel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('hour', models.CharField(choices=[('00', '00'), ('01', '01'), ('02', '02'), ('03', '03'), ('04', '04'), ('05', '05'), ('06', '06'), ('07', '07'), ('08', '08'), ('09', '09'), ('10', '10'), ('11', '11'), ('12', '12'), ('13', '13'), ('14', '14'), ('15', '15'), ('16', '16'), ('17', '17'), ('18', '18'), ('19', '19'), ('20', '20'), ('21', '21'), ('22', '22'), ('23', '23')], max_length=6)),
                ('fault', models.TextField()),
                ('corrective_action', models.TextField(blank=True, null=True)),
                ('result', models.TextField(blank=True, null=True)),
                ('created_by', models.CharField(max_length=24)),
                ('datetime_created', models.DateTimeField(auto_now_add=True)),
                ('line_id', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fault', to='line_analysis.lineanalysismodel')),
            ],
        ),
    ]
