from django.forms import ModelForm
from .models import LineAnalysisModel, LineFaultModel, LineAnalysisWorkFlowModel, LineAnalysisFilesModel
from .models_analysis import LineAlcModel, LineNonAlcModel



""" LINE ANALYSIS FORM """
class LineAnalysisForm(ModelForm):
    class Meta:
        model = LineAnalysisModel
        #fields = ['pub_date', 'headline', 'content', 'reporter']
        exclude = ['status', 'datetime_created', 'created_by']

""" LINE ANALYSIS FAULT FORM """
class LineFaultForm(ModelForm):
    class Meta:
        model = LineFaultModel
        exclude = ['line_id', 'datetime_created', 'created_by']


""" LINE ANALYSIS FAULT UPDATE FORM """
class LineFaultUpdateForm(ModelForm):
    class Meta:
        model = LineFaultModel
        exclude = ['line_id', 'hour', 'datetime_created', 'created_by']



""" LINE ANALYSIS HOURLY ALCOHOLIC FORM """
class LineAlcoholicAnalysisForm(ModelForm):
    class Meta:
        model = LineAlcModel
        exclude = ['line_id', 'datetime_created', 'created_by']


""" LINE ANALYSIS HOURLY UPDATE ALCOHOLIC FORM """
class LineAlcoholicAnalysisUpdateForm(ModelForm):
    class Meta:
        model = LineAlcModel
        exclude = ['line_id', 'hour', 'datetime_created', 'created_by']


""" LINE ANALYSIS HOURLY NON-ALCOHOLIC FORM """
class LineNonAlcoholicAnalysisForm(ModelForm):
    class Meta:
        model = LineNonAlcModel
        exclude = ['line_id', 'datetime_created', 'created_by']


""" LINE ANALYSIS HOURLY UPDATE NON-ALCOHOLIC FORM """
class LineNonAlcoholicAnalysisUpdateForm(ModelForm):
    class Meta:
        model = LineNonAlcModel
        exclude = ['line_id', 'hour', 'datetime_created', 'created_by']



""" ANALYSIS LINE ANALYSIS WORKFLOW FORM """
class LineAnalysisWorkflowForm(ModelForm):
    class Meta:
        model = LineAnalysisWorkFlowModel
        fields = ['analysed_comment']

    
""" CHECK LINE ANALYSIS WORKFLOW FORM """
class LineCheckWorkflowForm(ModelForm):
    class Meta:
        model = LineAnalysisWorkFlowModel
        fields = ['checked_comment']


""" APPROVAL LINE ANALYSIS WORKFLOW FORM """
class LineApprovalWorkflowForm(ModelForm):
    class Meta:
        model = LineAnalysisWorkFlowModel
        fields = ['approved_comment']



""" FILES UPLOAD FORM """
from django import forms
from typing import Any
class LineAnalysisFilesModelForm(forms.ModelForm):    
    file = forms.FileField(widget=forms.FileInput(attrs={"class": "col-12 form-control mb-3"}))
    class Meta:
        model = LineAnalysisFilesModel
        fields = ['file']

        def __init__(self, *args: Any, **kwargs: Any) -> None:
            super(LineAnalysisFilesModelForm, self).__init__(*args, **kwargs)

            self.fields['file'].help_text = None