from django.db import models
from django.utils import timezone
import time

status_choices = (('OPEN', 'OPEN'), ('CLOSED', 'CLOSED'))
MODEL_CHOICES = (('LINE_ANALYSIS', 'LINE_ANALYSIS'), ('SACHET_ANALYSIS', 'SACHET_ANALYSIS'), ('LINE_INSPECTION', 'LINE_INSPECTION'), ('SACHET_INSPECTION', 'SACHET_INSPECTION'))

class DisputeModel(models.Model):
    model_name = models.CharField(max_length=24, choices=MODEL_CHOICES) 
    model_id = models.IntegerField()
    dispute = models.TextField()
    status = models.CharField(max_length=8, choices=status_choices, default='OPEN')
    created_by = models.CharField(max_length=24, blank=True, null=True)
    datetime_created = models.DateTimeField(auto_now_add=True)
    
    closed_by = models.CharField(max_length=244, blank=True, null=True)
    close_comment = models.TextField(blank=True, null=True)
    datetime_closed = models.DateTimeField(blank=True, null=True)

    def __str__(self):
        return f"MODEL : {self.model_name},{self.dispute}"

    """
    def save(self, *args, **kwargs):
        self.dispute_ref_code = f"D/{self.status[0]}/{self.dispute_model}/{str(self.dispute_model_id).zfill(4)}/{time.time()}"
        return super().save(*args, **kwargs)
    """