"""core URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static


urlpatterns = [
    path('admin/', admin.site.urls),
    path('', include('accounts.urls')),
    path('', include('home.urls')),
    path('', include('django.contrib.auth.urls')),
    path('', include('accounts.urls')),
    path('line/analysis/', include('line_analysis.urls')),
    path('sachet/analysis/', include('sachet_analysis.urls')),
    path('line/inspection/', include('line_inspection.urls')),
    path('sachet/inspection/', include('sachet_inspection.urls')),
    path('report/', include('report.urls')),
    path('scan/', include('scan.urls')),
    path('dispute/', include('dispute.urls')),
    path('utils/', include('utilz.urls')),
    path('__debug__/', include('debug_toolbar.urls')),
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
