from django.contrib.auth.signals import user_logged_in, user_logged_out, user_login_failed
from django.dispatch import receiver
from accounts.models import UserProfile
from django.utils import timezone

@receiver(user_logged_in)
def log_user_login(sender, request, user, **kwargs):
    profile = request.user.profile_set
    profile.last_login = timezone.now()
    profile.save()



@receiver(user_logged_out)
def log_user_logout(sender, request, user, **kwargs):
    profile = request.user.profile_set
    profile.last_logout = timezone.now()
    profile.save()