from rest_framework import serializers
from django.contrib.auth.models import User
from .models import UserProfile

""" PROFILE SERILIZER """
class UserProfileSerializer(serializers.ModelSerializer):
    class Meta:
        model = UserProfile
        fields = ('id', 'role', 'is_delegated', 'last_logout', 'user', 'first_name')


# User Serializer
class UserSerializer(serializers.ModelSerializer):
    #profile = UserProfileSerializer(source='profile', many=True)
    class Meta:
        model = User
        fields = ['id', 'username', 'email', 'first_name', 'profile']

