from django import forms
from django.forms import ModelForm
from django.contrib.auth.models import User
from .models import UserProfile, MessageModel



from django.contrib.auth.forms import UserCreationForm
"""USER REGISTRATION FORM"""
class RegistrationForm(UserCreationForm):
    email = forms.EmailField(required=True)
    first_name = forms.CharField(max_length=30)
    last_name = forms.CharField(max_length=150)

    class Meta:
        model = User
        fields = ('username', 'email', 'first_name', 'last_name', 'password1', 'password2')

    def save(self, commit=True):
        user = super().save(commit=False)

        user.email = self.cleaned_data['email']
        user.first_name = self.cleaned_data['first_name']
        user.last_name = self.cleaned_data['last_name']

        if commit:
            user.save()
        return user




""" USER PROFILE FORM """
class UserProfileForm(ModelForm):
    class Meta:
        model = UserProfile
        #fields = ['pub_date', 'headline', 'content', 'reporter']
        exclude = ['user', 'datetime_created', 'created_by']


class UserProfileFormEdit(ModelForm):
    class Meta:
        model = UserProfile
        #fields = ['pub_date', 'headline', 'content', 'reporter']
        exclude = ['user', 'cadre', 'department', 'role', 'user_id', 'datetime_created', 'created_by']


""" CHAT MESSAGE FORM """
class MessageForm(ModelForm):
    def __init__(self,*args,**kwargs):
        super (MessageForm ,self ).__init__(*args,**kwargs) # populates the post
        self.fields['receiver'].queryset = User

    class Meta:
        model = MessageModel
        fields = ['receiver', 'message']