from django.contrib.auth.models import User
from django.shortcuts import render, redirect
from django.contrib.auth.decorators import login_required
from django.utils import timezone
from django.http.response import JsonResponse



@login_required(login_url='/login')
def users_api(request):
    users = [f"{u['first_name']} {u['last_name']}" for u in list(User.objects.all().values())]
    return JsonResponse(users, safe=False)